const mongoose = require('mongoose');

const QuizSubmissionSchema = new mongoose.Schema({
    // Store the user's name from the first input step
    userName: {
        type: String,
        required: true,
    },
    // Email is optional, captured in the final step of the quiz
    email: {
        type: String,
    },
    // Store the full set of answers {questionIndex: answerValue}
    answers: {
        type: Map,
        of: String,
        required: true,
    },
    // Calculated result category (e.g., 'dark', 'fresh', 'warm')
    scentType: {
        type: String,
    },
    // Products recommended based on the result
    recommendations: {
        type: [mongoose.Schema.Types.ObjectId],
        ref: 'Product', // Links to the Product model
        default: [],
    },
    isEmailSent: {
        type: Boolean,
        default: false,
    },
}, { timestamps: true });

module.exports = mongoose.model('QuizSubmission', QuizSubmissionSchema);