const mongoose = require('mongoose');

const QuizOptionSchema = new mongoose.Schema({
    id: { type: String, required: true },
    text: { type: String, required: true },
    image: { type: String }, // URL for image-choice steps
    value: { 
        type: String, 
        enum: ['fresh', 'dark', 'warm', 'floral', 'name', 'self', 'gift'], // Allowed scent/control values
        required: true 
    }
}, { _id: false });

const QuizQuestionSchema = new mongoose.Schema({
    order: {
        type: Number,
        required: true,
        unique: true, // Ensures questions are kept in a specific sequence
    },
    question: {
        type: String,
        required: true,
    },
    stepType: {
        type: String,
        enum: ['input', 'choice', 'image-choice'],
        required: true,
    },
    isMandatory: {
        type: Boolean,
        default: true,
    },
    options: {
        type: [QuizOptionSchema],
        default: [],
    },
}, { timestamps: true });

module.exports = mongoose.model('QuizQuestion', QuizQuestionSchema);