const mongoose = require('mongoose');

const WaitlistSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        required: true,
        unique: true,
    },
    // NEW FIELD: Stores the phone number for WhatsApp/Call
    phone: {
        type: String,
    },
    // UPDATED FIELD: Now an array to store multiple preferred contact types
    preferredContacts: {
        type: [String],
        enum: ['email', 'call', 'message', 'other'],
        default: ['email'],
    },
    quizResult: {
        type: String,
        // Stores the latest dominant result from the quiz (e.g., 'fresh', 'dark')
    },
    recommendations: {
        type: [String],
        // Array of recommended product names/IDs
        default: [],
    },
    isContacted: {
        type: Boolean,
        default: false,
    },
}, { timestamps: true });

module.exports = mongoose.model('Waitlist', WaitlistSchema);