const mongoose = require('mongoose');

const ProductSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
        unique: true,
    },
    subHeadline: String,
    category: {
        type: String,
        default: 'Eau de Parfum',
    },
    price: {
        type: Number,
        required: true,
    },
    productImageUrl: {
        type: String,
        required: true,
    },
    moodImageUrl: {
        type: String,
        required: true,
    },
    moodImageText: String,
    topNotes: [String],
    heartNotes: [String],
    baseNotes: [String],
    moodDescription: String,
    stock: {
        type: Number,
        default: 0,
    },
    moreInfoLink: String,
}, { timestamps: true });

module.exports = mongoose.model('Product', ProductSchema);