const nodemailer = require('nodemailer');

const transporter = nodemailer.createTransport({
    host: process.env.SMTP_HOST,
    port: process.env.SMTP_PORT,
    secure: process.env.SMTP_PORT === '465', // true for 465, false for other ports
    auth: {
        user: process.env.SMTP_USER,
        pass: process.env.SMTP_PASS,
    },
});

// --- CLIENT EMAIL TEMPLATE (FANCY HTML) ---

const sendWaitlistClientEmail = async (recipientEmail, recipientName) => {
    const htmlContent = `
        <div style="font-family: 'Inter', sans-serif; max-width: 600px; margin: auto; border: 1px solid #E5E7EB; border-radius: 8px; overflow: hidden; background-color: #FAF7F0;">
            
            <div style="background-color: #182A2E; padding: 25px 30px; text-align: center;">
                <h1 style="color: #F0CC6E; font-family: 'Times New Roman', serif; font-size: 30px; margin: 0; letter-spacing: 2px;">MIRAGEM</h1>
                <p style="color: #FAF7F0; font-size: 14px; margin: 5px 0 0;">The Journey Begins</p>
            </div>

            <div style="padding: 30px; color: #182A2E;">
                <h2 style="font-size: 24px; margin-top: 0; font-weight: 400;">Hello ${recipientName},</h2>
                <p style="font-size: 16px; line-height: 1.6;">
                    Welcome to the exclusive Miragem by Enid Nkini waitlist! Your presence here signifies the start of a journey into mysterious elegance.
                </p>
                <p style="font-size: 16px; line-height: 1.6; font-weight: 500;">
                    You are now guaranteed:
                </p>
                <ul style="font-size: 15px; padding-left: 20px; line-height: 1.8;">
                    <li>&#10003; Exclusive updates on our collection development.</li>
                    <li>&#10003; Early access to shop before the official launch.</li>
                    <li>&#10003; Special member-only offers.</li>
                </ul>

                <a href="[Your Website URL]" 
                   style="display: inline-block; background-color: #F0CC6E; color: #182A2E; padding: 12px 25px; margin-top: 25px; border-radius: 6px; text-decoration: none; font-weight: bold; text-transform: uppercase;">
                    Visit Miragem.com
                </a>
            </div>

            <div style="background-color: #182A2E; color: #FAF7F0; padding: 15px 30px; text-align: center; font-size: 12px;">
                <p style="margin: 0;">&copy; ${new Date().getFullYear()} Miragem by Enid Nkini. All rights reserved.</p>
            </div>
        </div>
    `;

    const mailOptions = {
        from: process.env.SENDER_EMAIL,
        to: recipientEmail,
        subject: 'Welcome to the Miragem Waitlist! 🌙',
        html: htmlContent,
    };

    await transporter.sendMail(mailOptions);
    console.log(`Waitlist confirmation email sent to client: ${recipientEmail}`);
};

// --- ADMIN EMAIL NOTIFICATION (PLAIN TEXT) ---

const sendWaitlistAdminNotification = async (data) => {
    const preferredList = data.preferredContacts.map(c => c.toUpperCase()).join(', ');
    const adminEmail = process.env.SMTP_USER; // Use the SMTP user email as the admin recipient

    const textContent = `
A new contact has joined the Miragem Waitlist!

--- CONTACT DETAILS ---
Name: ${data.name}
Email: ${data.email}
Phone: ${data.phone || 'N/A'}
Contact Preference(s): ${preferredList}
Registration Date: ${new Date().toLocaleDateString('en-US', { timeZone: 'UTC' })}

--- ACTION REQUIRED ---
Check the Admin Dashboard (Waitlist Manager) to mark this contact as 'contacted' and utilize the quiz results (if available) for personalized outreach.
`;

    const mailOptions = {
        from: process.env.SENDER_EMAIL,
        to: adminEmail,
        subject: `[New Waitlist Lead] ${data.name} - ${data.email}`,
        text: textContent,
    };

    await transporter.sendMail(mailOptions);
    console.log(`Waitlist notification sent to Admin: ${adminEmail}`);
};

module.exports = { transporter, sendWaitlistClientEmail, sendWaitlistAdminNotification };